#if !defined(AFX_PARSEDEMO_QW_H__48CAA081_C76C_11D2_BDFF_00400526D45A__INCLUDED_)
#define AFX_PARSEDEMO_QW_H__48CAA081_C76C_11D2_BDFF_00400526D45A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "msglog.h"
#include "demodata.h"
#include "error.h"
#include "writelog.h"
#include "outputfile.h"
#include "demodata.h"
#include "misc.h"
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <sys/stat.h>
#define QW_MAX_MSGLEN 32000
#define QW_MAX_BLOCKLEN 32000
#define QW_MAX_SCOREBOARD 31

typedef struct {
	long modelindex;
	long frame;
	long colormap;
	long skin;
	unsigned char effects;
	vec3_t origin;
	vec3_t angles;
	long default_modelindex;
	long default_frame;
	long default_colormap;
	long default_skin;
	vec3_t default_origin;
	vec3_t default_angles;
} entity_t;

class parsedemo_qw  
{
public:
	parsedemo_qw			(char* in_buf, long in_buflen);
	virtual ~parsedemo_qw	();
	void log				(demodata* in_data, configdata* in_config);
private:
	char*			buf;
	int				buf_len;
	char*			buf_pos;
	unsigned long	block_count;
	unsigned long	block_size;
	error*			err;
	msglog*			msg;
	demodata*		data;
	configdata*		config;
	misc*			misc;
	void			analyzeSpecialBlock (char* block, unsigned long len, int block_number);
	void			analyzeGameBlock (char* block, unsigned long len, float time);
	void			stringdown (unsigned char* str);
};

#endif // !defined(AFX_PARSEDEMO_QW_H__48CAA081_C76C_11D2_BDFF_00400526D45A__INCLUDED_)
